/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Iterator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import qouteall.q_misc_util.Helper;

public class MyTaskList {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ObjectList<MyTask> tasks = new ObjectArrayList();
    private final ObjectList<MyTask> tasksToAdd = new ObjectArrayList();

    public synchronized void addTask(MyTask task) {
        this.tasksToAdd.add((Object)task);
    }

    public void addOneShotTask(Runnable runnable) {
        this.addTask(() -> {
            runnable.run();
            return true;
        });
    }

    public synchronized void processTasks() {
        this.tasks.addAll(this.tasksToAdd);
        this.tasksToAdd.clear();
        Helper.removeIf(this.tasks, task -> {
            try {
                return task.runAndGetIsFinished();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to process task {}", task, (Object)e);
                return true;
            }
        });
    }

    public synchronized void forceClearTasks() {
        for (MyTask task : this.tasks) {
            task.onCancelled();
        }
        for (MyTask task : this.tasksToAdd) {
            task.onCancelled();
        }
        this.tasks.clear();
        this.tasksToAdd.clear();
    }

    public static MyTask oneShotTask(Runnable runnable) {
        return () -> {
            runnable.run();
            return true;
        };
    }

    public static MyTask nullTask() {
        return () -> true;
    }

    public static MyTask chainTask(final MyTask a, final MyTask b) {
        return new MyTask(){
            boolean aFinished = false;

            @Override
            public boolean runAndGetIsFinished() {
                if (!this.aFinished) {
                    boolean finished = a.runAndGetIsFinished();
                    if (finished) {
                        this.aFinished = true;
                    } else {
                        return false;
                    }
                }
                return b.runAndGetIsFinished();
            }

            @Override
            public void onCancelled() {
                if (!this.aFinished) {
                    a.onCancelled();
                }
                b.onCancelled();
            }
        };
    }

    public static MyTask withDelay(final int iterations, final MyTask task) {
        return new MyTask(){
            private int counter;
            {
                this.counter = iterations;
            }

            @Override
            public boolean runAndGetIsFinished() {
                if (this.counter > 0) {
                    --this.counter;
                    return false;
                }
                return task.runAndGetIsFinished();
            }

            @Override
            public void onCancelled() {
                task.onCancelled();
            }
        };
    }

    public static MyTask withCancelCondition(final BooleanSupplier shouldCancel, final MyTask task) {
        return new MyTask(){

            @Override
            public boolean runAndGetIsFinished() {
                if (shouldCancel.getAsBoolean()) {
                    return true;
                }
                return task.runAndGetIsFinished();
            }

            @Override
            public void onCancelled() {
                task.onCancelled();
            }
        };
    }

    public static MyTask withDelayCondition(final BooleanSupplier shouldDelay, final MyTask task) {
        return new MyTask(){

            @Override
            public boolean runAndGetIsFinished() {
                if (shouldDelay.getAsBoolean()) {
                    return false;
                }
                return task.runAndGetIsFinished();
            }

            @Override
            public void onCancelled() {
                task.onCancelled();
            }
        };
    }

    public static MyTask withTimeDelayedFromNow(double seconds, MyTask task) {
        long startTime = System.nanoTime();
        return MyTaskList.withDelayCondition(() -> System.nanoTime() - startTime < Helper.secondToNano(seconds), task);
    }

    public static MyTask withRetryNumberLimit(final int retryNumberLimit, final MyTask task, final Runnable onLimitReached) {
        return new MyTask(){
            private int retryNumber = 0;

            @Override
            public boolean runAndGetIsFinished() {
                boolean finished = task.runAndGetIsFinished();
                if (finished) {
                    return true;
                }
                ++this.retryNumber;
                if (this.retryNumber > retryNumberLimit) {
                    onLimitReached.run();
                    return true;
                }
                return false;
            }

            @Override
            public void onCancelled() {
                task.onCancelled();
            }
        };
    }

    public static MyTask withInterval(final int interval, final MyTask task) {
        return new MyTask(){
            int i = 0;

            @Override
            public boolean runAndGetIsFinished() {
                if (this.i < interval) {
                    ++this.i;
                    return false;
                }
                this.i = 0;
                return task.runAndGetIsFinished();
            }

            @Override
            public void onCancelled() {
                task.onCancelled();
            }
        };
    }

    public static MyTask withMacroLifecycle(final Runnable beginAction, final Runnable endAction, final MyTask task) {
        return new MyTask(){
            boolean began = false;

            @Override
            public boolean runAndGetIsFinished() {
                boolean finished;
                if (!this.began) {
                    this.began = true;
                    beginAction.run();
                }
                if (finished = task.runAndGetIsFinished()) {
                    endAction.run();
                }
                return finished;
            }

            @Override
            public void onCancelled() {
                if (this.began) {
                    endAction.run();
                }
                task.onCancelled();
            }
        };
    }

    public static MyTask withMicroLifecycle(final Runnable beginAction, final Runnable endAction, final MyTask task) {
        return new MyTask(){

            @Override
            public boolean runAndGetIsFinished() {
                beginAction.run();
                boolean finished = task.runAndGetIsFinished();
                endAction.run();
                return finished;
            }

            @Override
            public void onCancelled() {
                endAction.run();
                task.onCancelled();
            }
        };
    }

    public static MyTask chainTasks(Iterator<MyTask> tasks) {
        final PeekingIterator peekingIterator = Iterators.peekingIterator(tasks);
        return new MyTask(){

            @Override
            public boolean runAndGetIsFinished() {
                MyTask curr;
                boolean finished;
                if (peekingIterator.hasNext() && (finished = (curr = (MyTask)peekingIterator.peek()).runAndGetIsFinished())) {
                    peekingIterator.next();
                }
                return !peekingIterator.hasNext();
            }

            @Override
            public void onCancelled() {
                while (peekingIterator.hasNext()) {
                    MyTask curr = (MyTask)peekingIterator.next();
                    curr.onCancelled();
                }
            }
        };
    }

    public static MyTask repeat(int number, Supplier<MyTask> taskConstructor) {
        return MyTaskList.chainTasks(Stream.generate(taskConstructor).limit(number).iterator());
    }

    public static interface MyTask {
        public boolean runAndGetIsFinished();

        default public void onCancelled() {
        }
    }
}

